/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osmdroid.bonuspack.kml.KmlLineString;
import org.osmdroid.bonuspack.kml.KmlPoint;
import org.osmdroid.bonuspack.kml.KmlPolygon;
import org.osmdroid.util.GeoPoint;

public abstract class KmlGeometry
implements Cloneable,
Parcelable {
    public static final int UNKNOWN = 0;
    public static final int POINT = 1;
    public static final int LINE_STRING = 2;
    public static final int POLYGON = 3;
    public int mType;
    public String mId;
    public ArrayList<GeoPoint> mCoordinates;

    public KmlGeometry() {
        this.mType = 0;
    }

    public boolean isA(int geomType) {
        return this.mType == geomType;
    }

    public boolean writeKMLCoordinates(Writer writer, ArrayList<GeoPoint> coordinates) {
        try {
            writer.write("<coordinates>");
            for (GeoPoint coord : coordinates) {
                writer.write(coord.toInvertedDoubleString());
                writer.write(32);
            }
            writer.write("</coordinates>\n");
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static JSONArray geoJSONPosition(GeoPoint position) {
        try {
            JSONArray json = new JSONArray();
            json.put(position.getLongitude());
            json.put(position.getLatitude());
            return json;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static JSONArray geoJSONCoordinates(ArrayList<GeoPoint> coordinates) {
        JSONArray json = new JSONArray();
        for (GeoPoint position : coordinates) {
            json.put((Object)KmlGeometry.geoJSONPosition(position));
        }
        return json;
    }

    public static ArrayList<GeoPoint> cloneArrayOfGeoPoint(ArrayList<GeoPoint> coords) {
        ArrayList<GeoPoint> result = new ArrayList<GeoPoint>(coords.size());
        for (GeoPoint p : coords) {
            result.add(p.clone());
        }
        return result;
    }

    public abstract void saveAsKML(Writer var1);

    public abstract JSONObject asGeoJSON();

    public static GeoPoint parseGeoJSONPosition(JSONArray json) {
        return new GeoPoint(json.optDouble(1, 0.0), json.optDouble(0, 0.0), json.optDouble(2, 0.0));
    }

    public static ArrayList<GeoPoint> parseGeoJSONPositions(JSONArray json) {
        if (json == null) {
            return null;
        }
        ArrayList<GeoPoint> coordinates = new ArrayList<GeoPoint>(json.length());
        int i = 0;
        while (i < json.length()) {
            JSONArray position = json.optJSONArray(i);
            GeoPoint p = KmlGeometry.parseGeoJSONPosition(position);
            if (p != null) {
                coordinates.add(p);
            }
            ++i;
        }
        return coordinates;
    }

    public static KmlGeometry parseGeoJSON(JSONObject json) {
        if (json == null) {
            return null;
        }
        String type = json.optString("type");
        if ("Point".equals(type)) {
            return new KmlPoint(json);
        }
        if ("LineString".equals(type)) {
            return new KmlLineString(json);
        }
        if ("Polygon".equals(type)) {
            return new KmlPolygon(json);
        }
        return null;
    }

    public KmlGeometry clone() {
        KmlGeometry kmlGeometry = null;
        try {
            kmlGeometry = (KmlGeometry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
        if (this.mCoordinates != null) {
            kmlGeometry.mCoordinates = KmlGeometry.cloneArrayOfGeoPoint(this.mCoordinates);
        }
        return kmlGeometry;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mType);
        out.writeString(this.mId);
        out.writeList(this.mCoordinates);
    }

    public KmlGeometry(Parcel in) {
        this.mType = in.readInt();
        this.mId = in.readString();
        this.mCoordinates = in.readArrayList(GeoPoint.class.getClassLoader());
    }
}

