/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osmdroid.bonuspack.clustering.GridMarkerClusterer;
import org.osmdroid.bonuspack.clustering.MarkerClusterer;
import org.osmdroid.bonuspack.kml.KmlDocument;
import org.osmdroid.bonuspack.kml.KmlFeature;
import org.osmdroid.bonuspack.kml.KmlGroundOverlay;
import org.osmdroid.bonuspack.kml.KmlPlacemark;
import org.osmdroid.bonuspack.overlays.FolderOverlay;
import org.osmdroid.bonuspack.overlays.GroundOverlay;
import org.osmdroid.bonuspack.overlays.Marker;
import org.osmdroid.bonuspack.overlays.Polygon;
import org.osmdroid.bonuspack.overlays.Polyline;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Overlay;

public class KmlFolder
extends KmlFeature
implements Cloneable,
Parcelable {
    public ArrayList<KmlFeature> mItems;
    public static final Parcelable.Creator<KmlFolder> CREATOR = new Parcelable.Creator<KmlFolder>(){

        public KmlFolder createFromParcel(Parcel source) {
            return new KmlFolder(source);
        }

        public KmlFolder[] newArray(int size) {
            return new KmlFolder[size];
        }
    };

    public KmlFolder() {
        this.mObjectType = 5;
        this.mItems = new ArrayList();
    }

    public KmlFolder(FolderOverlay overlay, KmlDocument kmlDoc) {
        this();
        this.addOverlays(overlay.getItems(), kmlDoc);
        this.mName = overlay.getName();
        this.mDescription = overlay.getDescription();
        this.mVisibility = overlay.isEnabled();
    }

    public KmlFolder(MarkerClusterer overlay, KmlDocument kmlDoc) {
        this();
        this.addOverlays(overlay.getItems(), kmlDoc);
        this.mVisibility = overlay.isEnabled();
    }

    public KmlFolder(JSONObject json) {
        this();
        JSONArray features = json.optJSONArray("features");
        if (features != null) {
            int i = 0;
            while (i < features.length()) {
                JSONObject featureJSON = features.optJSONObject(i);
                if (featureJSON != null) {
                    this.mItems.add(KmlFeature.parseGeoJSON(featureJSON));
                }
                ++i;
            }
        }
    }

    public boolean addOverlay(Overlay overlay, KmlDocument kmlDoc) {
        KmlFeature kmlItem;
        if (overlay == null) {
            return false;
        }
        if (overlay.getClass() == GroundOverlay.class) {
            kmlItem = new KmlGroundOverlay((GroundOverlay)overlay);
        } else if (overlay.getClass() == FolderOverlay.class) {
            kmlItem = new KmlFolder((FolderOverlay)overlay, kmlDoc);
        } else if (overlay.getClass() == GridMarkerClusterer.class) {
            kmlItem = new KmlFolder((MarkerClusterer)overlay, kmlDoc);
        } else if (overlay.getClass() == Marker.class) {
            Marker marker = (Marker)overlay;
            kmlItem = new KmlPlacemark(marker);
        } else if (overlay.getClass() == Polygon.class) {
            Polygon polygon = (Polygon)overlay;
            kmlItem = new KmlPlacemark(polygon, kmlDoc);
        } else if (overlay.getClass() == Polyline.class) {
            Polyline polyline = (Polyline)overlay;
            kmlItem = new KmlPlacemark(polyline, kmlDoc);
        } else {
            return false;
        }
        this.mItems.add(kmlItem);
        this.updateBoundingBoxWith(kmlItem.mBB);
        return true;
    }

    public void addOverlays(List<? extends Overlay> overlays, KmlDocument kmlDoc) {
        if (overlays != null) {
            for (Overlay overlay : overlays) {
                this.addOverlay(overlay, kmlDoc);
            }
        }
    }

    public void add(KmlFeature item) {
        this.mItems.add(item);
        this.updateBoundingBoxWith(item.mBB);
    }

    public KmlFeature removeItem(int itemPosition) {
        KmlFeature removed = this.mItems.remove(itemPosition);
        this.mBB = null;
        for (KmlFeature item : this.mItems) {
            this.updateBoundingBoxWith(item.mBB);
        }
        return removed;
    }

    @Override
    public FolderOverlay buildOverlay(MapView map, Drawable defaultIcon, KmlDocument kmlDocument, boolean supportVisibility) {
        Context context = map.getContext();
        FolderOverlay folderOverlay = new FolderOverlay(context);
        for (KmlFeature k : this.mItems) {
            Overlay overlay = k.buildOverlay(map, defaultIcon, kmlDocument, supportVisibility);
            folderOverlay.add(overlay);
        }
        if (!this.mVisibility) {
            folderOverlay.setEnabled(false);
        }
        return folderOverlay;
    }

    @Override
    public void writeKMLSpecifics(Writer writer) {
        try {
            if (!this.mOpen) {
                writer.write("<open>0</open>\n");
            }
            for (KmlFeature item : this.mItems) {
                item.writeAsKML(writer, false, null);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public JSONObject asGeoJSON(boolean isRoot) {
        try {
            JSONObject json = new JSONObject();
            if (isRoot) {
                json.put("type", (Object)"FeatureCollection");
            }
            JSONArray features = new JSONArray();
            for (KmlFeature item : this.mItems) {
                JSONObject subJson = item.asGeoJSON(false);
                if (item.isA(5)) {
                    JSONArray subFeatures = subJson.optJSONArray("features");
                    if (features == null) continue;
                    int i = 0;
                    while (i < subFeatures.length()) {
                        JSONObject j = subFeatures.getJSONObject(i);
                        features.put((Object)j);
                        ++i;
                    }
                    continue;
                }
                if (subJson == null) continue;
                features.put((Object)subJson);
            }
            json.put("features", (Object)features);
            if (isRoot) {
                JSONObject crs = new JSONObject();
                crs.put("type", (Object)"name");
                JSONObject properties = new JSONObject();
                properties.put("name", (Object)"urn:ogc:def:crs:OGC:1.3:CRS84");
                crs.put("properties", (Object)properties);
                json.put("crs", (Object)crs);
            }
            return json;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public KmlFolder clone() {
        KmlFolder kmlFolder = (KmlFolder)super.clone();
        if (this.mItems != null) {
            kmlFolder.mItems = new ArrayList(this.mItems.size());
            for (KmlFeature item : this.mItems) {
                kmlFolder.mItems.add(item.clone());
            }
        }
        return kmlFolder;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        out.writeList(this.mItems);
    }

    public KmlFolder(Parcel in) {
        super(in);
        this.mItems = in.readArrayList(KmlFeature.class.getClassLoader());
    }
}

