/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import org.osmdroid.bonuspack.kml.KmlDocument;
import org.osmdroid.bonuspack.kml.KmlFolder;
import org.osmdroid.bonuspack.kml.KmlGeometry;
import org.osmdroid.bonuspack.kml.KmlPlacemark;
import org.osmdroid.util.BoundingBoxE6;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Overlay;

public abstract class KmlFeature
implements Parcelable,
Cloneable {
    public static final int UNKNOWN = 0;
    public static final int PLACEMARK = 1;
    public static final int GROUND_OVERLAY = 4;
    public static final int FOLDER = 5;
    public int mObjectType;
    public String mId;
    public String mName;
    public String mDescription;
    public boolean mVisibility;
    public boolean mOpen;
    public String mStyle;
    public HashMap<String, String> mExtendedData;
    public BoundingBoxE6 mBB;

    public KmlFeature() {
        this.mObjectType = 0;
        this.mVisibility = true;
        this.mOpen = true;
    }

    public boolean isA(int objectType) {
        return this.mObjectType == objectType;
    }

    public boolean hasGeometry(int geomType) {
        if (!this.isA(1)) {
            return false;
        }
        KmlPlacemark placemark = (KmlPlacemark)this;
        KmlGeometry geometry = placemark.mGeometry;
        if (geometry == null) {
            return false;
        }
        return geometry.isA(geomType);
    }

    public void updateBoundingBoxWith(BoundingBoxE6 itemBB) {
        if (itemBB != null) {
            this.mBB = this.mBB == null ? new BoundingBoxE6(itemBB.getLatNorthE6(), itemBB.getLonEastE6(), itemBB.getLatSouthE6(), itemBB.getLonWestE6()) : new BoundingBoxE6(Math.max(itemBB.getLatNorthE6(), this.mBB.getLatNorthE6()), Math.max(itemBB.getLonEastE6(), this.mBB.getLonEastE6()), Math.min(itemBB.getLatSouthE6(), this.mBB.getLatSouthE6()), Math.min(itemBB.getLonWestE6(), this.mBB.getLonWestE6()));
        }
    }

    public void setExtendedData(String name, String value) {
        if (this.mExtendedData == null) {
            this.mExtendedData = new HashMap();
        }
        this.mExtendedData.put(name, value);
    }

    public abstract Overlay buildOverlay(MapView var1, Drawable var2, KmlDocument var3, boolean var4);

    public abstract void writeKMLSpecifics(Writer var1);

    public abstract JSONObject asGeoJSON(boolean var1);

    protected boolean writeKMLExtendedData(Writer writer) {
        if (this.mExtendedData == null) {
            return true;
        }
        try {
            writer.write("<ExtendedData>\n");
            for (Map.Entry<String, String> entry : this.mExtendedData.entrySet()) {
                String name = entry.getKey();
                String value = entry.getValue();
                writer.write("<Data name=\"" + name + "\"><value>" + value + "</value></Data>\n");
            }
            writer.write("</ExtendedData>\n");
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean writeAsKML(Writer writer, boolean isDocument, KmlDocument kmlDocument) {
        try {
            String objectType;
            switch (this.mObjectType) {
                case 5: {
                    if (isDocument) {
                        objectType = "Document";
                        break;
                    }
                    objectType = "Folder";
                    break;
                }
                case 1: {
                    objectType = "Placemark";
                    break;
                }
                case 4: {
                    objectType = "GroundOverlay";
                    break;
                }
                default: {
                    objectType = "Unknown";
                }
            }
            writer.write(String.valueOf('<') + objectType);
            if (this.mId != null) {
                writer.write(" id=\"mId\"");
            }
            writer.write(">\n");
            if (this.mStyle != null) {
                writer.write("<styleUrl>#" + this.mStyle + "</styleUrl>\n");
            }
            if (this.mName != null) {
                writer.write("<name>" + this.mName + "</name>\n");
            }
            if (this.mDescription != null) {
                writer.write("<description><![CDATA[" + this.mDescription + "]]></description>\n");
            }
            if (!this.mVisibility) {
                writer.write("<visibility>0</visibility>\n");
            }
            this.writeKMLSpecifics(writer);
            this.writeKMLExtendedData(writer);
            if (isDocument) {
                kmlDocument.writeKMLStyles(writer);
            }
            writer.write("</" + objectType + ">\n");
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static KmlFeature parseGeoJSON(JSONObject json) {
        if (json == null) {
            return null;
        }
        String type = json.optString("type");
        if ("FeatureCollection".equals(type)) {
            return new KmlFolder(json);
        }
        if ("Feature".equals(type)) {
            return new KmlPlacemark(json);
        }
        return null;
    }

    public KmlFeature clone() {
        KmlFeature kmlFeature = null;
        try {
            kmlFeature = (KmlFeature)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
        if (this.mExtendedData != null) {
            kmlFeature.mExtendedData = new HashMap(this.mExtendedData.size());
            kmlFeature.mExtendedData.putAll(this.mExtendedData);
        }
        if (this.mBB != null) {
            kmlFeature.mBB = new BoundingBoxE6(this.mBB.getLatNorthE6(), this.mBB.getLonEastE6(), this.mBB.getLatSouthE6(), this.mBB.getLonWestE6());
        }
        return kmlFeature;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeInt(this.mObjectType);
        out.writeString(this.mId);
        out.writeString(this.mName);
        out.writeString(this.mDescription);
        out.writeInt(this.mVisibility ? 1 : 0);
        out.writeInt(this.mOpen ? 1 : 0);
        out.writeString(this.mStyle);
        out.writeParcelable((Parcelable)this.mBB, flags);
    }

    public KmlFeature(Parcel in) {
        this.mObjectType = in.readInt();
        this.mId = in.readString();
        this.mName = in.readString();
        this.mDescription = in.readString();
        this.mVisibility = in.readInt() == 1;
        this.mOpen = in.readInt() == 1;
        this.mStyle = in.readString();
        this.mBB = (BoundingBoxE6)in.readParcelable(BoundingBoxE6.class.getClassLoader());
    }
}

