/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.os.Environment;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.osmdroid.bonuspack.kml.ColorStyle;
import org.osmdroid.bonuspack.kml.IconStyle;
import org.osmdroid.bonuspack.kml.KmlFeature;
import org.osmdroid.bonuspack.kml.KmlFolder;
import org.osmdroid.bonuspack.kml.KmlGeometry;
import org.osmdroid.bonuspack.kml.KmlGroundOverlay;
import org.osmdroid.bonuspack.kml.KmlLineString;
import org.osmdroid.bonuspack.kml.KmlPlacemark;
import org.osmdroid.bonuspack.kml.KmlPoint;
import org.osmdroid.bonuspack.kml.KmlPolygon;
import org.osmdroid.bonuspack.kml.LineStyle;
import org.osmdroid.bonuspack.kml.Style;
import org.osmdroid.bonuspack.utils.BonusPackHelper;
import org.osmdroid.bonuspack.utils.HttpConnection;
import org.osmdroid.util.BoundingBoxE6;
import org.osmdroid.util.GeoPoint;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class KmlDocument
implements Parcelable {
    public KmlFolder mKmlRoot;
    protected HashMap<String, Style> mStyles;
    protected int mMaxStyleId;
    public static final Parcelable.Creator<KmlDocument> CREATOR = new Parcelable.Creator<KmlDocument>(){

        public KmlDocument createFromParcel(Parcel source) {
            return new KmlDocument(source);
        }

        public KmlDocument[] newArray(int size) {
            return new KmlDocument[size];
        }
    };

    public KmlDocument() {
        this.mStyles = new HashMap();
        this.mMaxStyleId = 0;
        this.mKmlRoot = new KmlFolder();
    }

    public Style getStyle(String styleId) {
        return this.mStyles.get(styleId);
    }

    public void putStyle(String styleId, Style style) {
        try {
            int id = Integer.parseInt(styleId);
            this.mMaxStyleId = Math.max(this.mMaxStyleId, id);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.mStyles.put(styleId, style);
    }

    public String addStyle(Style style) {
        ++this.mMaxStyleId;
        String newId = "" + this.mMaxStyleId;
        this.putStyle(newId, style);
        return newId;
    }

    protected static GeoPoint parseKmlCoord(String input) {
        int end1 = input.indexOf(44);
        int end2 = input.indexOf(44, end1 + 1);
        try {
            if (end2 == -1) {
                double lon = Double.parseDouble(input.substring(0, end1));
                double lat = Double.parseDouble(input.substring(end1 + 1, input.length()));
                return new GeoPoint(lat, lon);
            }
            double lon = Double.parseDouble(input.substring(0, end1));
            double lat = Double.parseDouble(input.substring(end1 + 1, end2));
            double alt = Double.parseDouble(input.substring(end2 + 1, input.length()));
            return new GeoPoint(lat, lon, alt);
        }
        catch (NumberFormatException e) {
            return null;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    protected static ArrayList<GeoPoint> parseKmlCoordinates(String input) {
        LinkedList<GeoPoint> tmpCoords = new LinkedList<GeoPoint>();
        int i = 0;
        int tupleStart = 0;
        int length = input.length();
        boolean startReadingTuple = false;
        while (i < length) {
            GeoPoint p;
            String tuple;
            char c = input.charAt(i);
            if (c == ' ' || c == '\n' || c == '\t') {
                if (startReadingTuple) {
                    tuple = input.substring(tupleStart, i);
                    p = KmlDocument.parseKmlCoord(tuple);
                    if (p != null) {
                        tmpCoords.add(p);
                    }
                    startReadingTuple = false;
                }
            } else {
                if (!startReadingTuple) {
                    startReadingTuple = true;
                    tupleStart = i;
                }
                if (i == length - 1 && (p = KmlDocument.parseKmlCoord(tuple = input.substring(tupleStart, i + 1))) != null) {
                    tmpCoords.add(p);
                }
            }
            ++i;
        }
        ArrayList<GeoPoint> coordinates = new ArrayList<GeoPoint>(tmpCoords.size());
        coordinates.addAll(tmpCoords);
        return coordinates;
    }

    public boolean parseUrl(String url) {
        Log.d((String)"BONUSPACK", (String)("KmlProvider.parseUrl:" + url));
        HttpConnection connection = new HttpConnection();
        connection.doGet(url);
        InputStream stream = connection.getStream();
        if (stream == null) {
            this.mKmlRoot = null;
        } else {
            this.parseStream(stream, url);
        }
        connection.close();
        return this.mKmlRoot != null;
    }

    public File getDefaultPathForAndroid(String fileName) {
        try {
            File path = new File(Environment.getExternalStorageDirectory(), "kml");
            path.mkdir();
            File file = new File(path.getAbsolutePath(), fileName);
            return file;
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean parseFile(File file) {
        Log.d((String)"BONUSPACK", (String)("KmlProvider.parseFile:" + file.getAbsolutePath()));
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(new FileInputStream(file));
            this.parseStream(stream, file.getAbsolutePath());
            ((InputStream)stream).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mKmlRoot = null;
        }
        return this.mKmlRoot != null;
    }

    public boolean parseStream(InputStream stream, String fullFilePath) {
        KmlSaxHandler handler = new KmlSaxHandler(fullFilePath);
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(stream, (DefaultHandler)handler);
            this.mKmlRoot = handler.mKmlRoot;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mKmlRoot = null;
        }
        return this.mKmlRoot != null;
    }

    public boolean saveAsKML(Writer writer) {
        try {
            writer.write("<?xml version='1.0' encoding='UTF-8'?>\n");
            writer.write("<kml xmlns='http://www.opengis.net/kml/2.2'>\n");
            boolean result = true;
            if (this.mKmlRoot != null) {
                result = this.mKmlRoot.writeAsKML(writer, true, this);
            }
            writer.write("</kml>\n");
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void writeKMLStyles(Writer writer) {
        for (Map.Entry<String, Style> entry : this.mStyles.entrySet()) {
            String styleId = entry.getKey();
            Style style = entry.getValue();
            style.writeAsKML(writer, styleId);
        }
    }

    public boolean saveAsKML(File file) {
        try {
            Log.d((String)"BONUSPACK", (String)("Saving " + file.getAbsolutePath()));
            FileWriter fw = new FileWriter(file);
            BufferedWriter writer = new BufferedWriter(fw, 8192);
            boolean result = this.saveAsKML(writer);
            writer.close();
            Log.d((String)"BONUSPACK", (String)"Saved.");
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean saveAsGeoJSON(Writer writer) {
        JSONObject json = this.mKmlRoot.asGeoJSON(true);
        if (json == null) {
            return false;
        }
        try {
            writer.write(json.toString(2));
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean saveAsGeoJSON(File file) {
        try {
            FileWriter fw = new FileWriter(file);
            BufferedWriter writer = new BufferedWriter(fw, 8192);
            boolean result = this.saveAsGeoJSON(writer);
            writer.close();
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean parseGeoJSON(JSONObject json) {
        KmlFeature feature = KmlFeature.parseGeoJSON(json);
        if (feature.isA(5)) {
            this.mKmlRoot = (KmlFolder)feature;
        } else {
            this.mKmlRoot = new KmlFolder();
            this.mKmlRoot.add(feature);
        }
        return true;
    }

    public boolean parseGeoJSON(String jsonString) {
        try {
            return this.parseGeoJSON(new JSONObject(jsonString));
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean parseGeoJSON(File file) {
        try {
            FileInputStream input = new FileInputStream(file);
            String s = BonusPackHelper.convertStreamToString(input);
            input.close();
            return this.parseGeoJSON(s);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeParcelable((Parcelable)this.mKmlRoot, flags);
        out.writeInt(this.mStyles.size());
        for (String key : this.mStyles.keySet()) {
            out.writeString(key);
            out.writeParcelable((Parcelable)this.mStyles.get(key), flags);
        }
        out.writeInt(this.mMaxStyleId);
    }

    public KmlDocument(Parcel in) {
        this.mKmlRoot = (KmlFolder)in.readParcelable(KmlFeature.class.getClassLoader());
        int size = in.readInt();
        this.mStyles = new HashMap(size);
        int i = 0;
        while (i < size) {
            String key = in.readString();
            Style value = (Style)in.readParcelable(Style.class.getClassLoader());
            this.mStyles.put(key, value);
            ++i;
        }
        this.mMaxStyleId = in.readInt();
    }

    class KmlSaxHandler
    extends DefaultHandler {
        private StringBuilder mStringBuilder = new StringBuilder(1024);
        private KmlFeature mKmlCurrentFeature;
        private KmlGroundOverlay mKmlCurrentGroundOverlay;
        private ArrayList<KmlFeature> mKmlStack;
        public KmlFolder mKmlRoot;
        Style mCurrentStyle;
        String mCurrentStyleId;
        ColorStyle mColorStyle;
        String mDataName;
        boolean mIsNetworkLink;
        boolean mIsInnerBoundary;
        String mFullPath;
        double mNorth;
        double mEast;
        double mSouth;
        double mWest;

        public KmlSaxHandler(String fullPath) {
            this.mFullPath = fullPath;
            this.mKmlRoot = new KmlFolder();
            this.mKmlStack = new ArrayList();
            this.mKmlStack.add(this.mKmlRoot);
            this.mIsNetworkLink = false;
            this.mIsInnerBoundary = false;
        }

        protected void loadNetworkLink(String href) {
            KmlDocument subDocument = new KmlDocument();
            if (href.startsWith("http://")) {
                subDocument.parseUrl(href);
            } else {
                File file = new File(this.mFullPath);
                File subFile = new File(String.valueOf(file.getParent()) + '/' + href);
                subDocument.parseFile(subFile);
            }
            if (subDocument.mKmlRoot != null) {
                ((KmlFolder)this.mKmlCurrentFeature).add(subDocument.mKmlRoot);
                KmlDocument.this.mStyles.putAll(subDocument.mStyles);
            } else {
                Log.e((String)"BONUSPACK", (String)("Error reading NetworkLink:" + href));
            }
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (localName.equals("Document")) {
                this.mKmlCurrentFeature = this.mKmlRoot;
                this.mKmlCurrentFeature.mId = attributes.getValue("id");
            } else if (localName.equals("Folder")) {
                this.mKmlCurrentFeature = new KmlFolder();
                this.mKmlCurrentFeature.mId = attributes.getValue("id");
                this.mKmlStack.add(this.mKmlCurrentFeature);
            } else if (localName.equals("NetworkLink")) {
                this.mKmlCurrentFeature = new KmlFolder();
                this.mKmlCurrentFeature.mId = attributes.getValue("id");
                this.mKmlStack.add(this.mKmlCurrentFeature);
                this.mIsNetworkLink = true;
            } else if (localName.equals("GroundOverlay")) {
                this.mKmlCurrentGroundOverlay = new KmlGroundOverlay();
                this.mKmlCurrentFeature = this.mKmlCurrentGroundOverlay;
                this.mKmlCurrentFeature.mId = attributes.getValue("id");
                this.mKmlStack.add(this.mKmlCurrentFeature);
            } else if (localName.equals("Placemark")) {
                this.mKmlCurrentFeature = new KmlPlacemark();
                this.mKmlCurrentFeature.mId = attributes.getValue("id");
                this.mKmlStack.add(this.mKmlCurrentFeature);
            } else if (localName.equals("Point")) {
                ((KmlPlacemark)this.mKmlCurrentFeature).mGeometry = new KmlPoint();
            } else if (localName.equals("LineString")) {
                ((KmlPlacemark)this.mKmlCurrentFeature).mGeometry = new KmlLineString();
            } else if (localName.equals("Polygon")) {
                ((KmlPlacemark)this.mKmlCurrentFeature).mGeometry = new KmlPolygon();
            } else if (localName.equals("innerBoundaryIs")) {
                this.mIsInnerBoundary = true;
            } else if (localName.equals("Style")) {
                this.mCurrentStyle = new Style();
                this.mCurrentStyleId = attributes.getValue("id");
            } else if (localName.equals("LineStyle")) {
                this.mCurrentStyle.mLineStyle = new LineStyle();
                this.mColorStyle = this.mCurrentStyle.mLineStyle;
            } else if (localName.equals("PolyStyle")) {
                this.mColorStyle = this.mCurrentStyle.mPolyStyle = new ColorStyle();
            } else if (localName.equals("IconStyle")) {
                this.mCurrentStyle.mIconStyle = new IconStyle();
                this.mColorStyle = this.mCurrentStyle.mIconStyle;
            } else if (localName.equals("hotSpot")) {
                if (this.mCurrentStyle != null && this.mCurrentStyle.mIconStyle != null) {
                    this.mCurrentStyle.mIconStyle.mHotSpotX = Float.parseFloat(attributes.getValue("x"));
                    this.mCurrentStyle.mIconStyle.mHotSpotY = Float.parseFloat(attributes.getValue("y"));
                }
            } else if (localName.equals("Data") || localName.equals("SimpleData")) {
                this.mDataName = attributes.getValue("name");
            }
            this.mStringBuilder.setLength(0);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.mStringBuilder.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if (!localName.equals("Document")) {
                if (localName.equals("Folder") || localName.equals("Placemark") || localName.equals("NetworkLink") || localName.equals("GroundOverlay")) {
                    KmlFolder parent = (KmlFolder)this.mKmlStack.get(this.mKmlStack.size() - 2);
                    parent.add(this.mKmlCurrentFeature);
                    this.mKmlStack.remove(this.mKmlStack.size() - 1);
                    this.mKmlCurrentFeature = this.mKmlStack.get(this.mKmlStack.size() - 1);
                    if (localName.equals("NetworkLink")) {
                        this.mIsNetworkLink = false;
                    } else if (localName.equals("GroundOverlay")) {
                        this.mKmlCurrentGroundOverlay = null;
                    }
                } else if (localName.equals("innerBoundaryIs")) {
                    this.mIsInnerBoundary = false;
                } else if (localName.equals("name")) {
                    this.mKmlCurrentFeature.mName = this.mStringBuilder.toString();
                } else if (localName.equals("description")) {
                    this.mKmlCurrentFeature.mDescription = this.mStringBuilder.toString();
                } else if (localName.equals("visibility")) {
                    this.mKmlCurrentFeature.mVisibility = "1".equals(this.mStringBuilder.toString());
                } else if (localName.equals("open")) {
                    this.mKmlCurrentFeature.mOpen = "1".equals(this.mStringBuilder.toString());
                } else if (localName.equals("coordinates")) {
                    if (this.mKmlCurrentFeature.isA(1)) {
                        KmlPlacemark kmlPlacemark = (KmlPlacemark)this.mKmlCurrentFeature;
                        KmlGeometry geometry = kmlPlacemark.mGeometry;
                        if (!this.mIsInnerBoundary) {
                            geometry.mCoordinates = KmlDocument.parseKmlCoordinates(this.mStringBuilder.toString());
                            this.mKmlCurrentFeature.mBB = BoundingBoxE6.fromGeoPoints(geometry.mCoordinates);
                        } else {
                            KmlPolygon polygon = (KmlPolygon)geometry;
                            if (polygon.mHoles == null) {
                                polygon.mHoles = new ArrayList();
                            }
                            ArrayList<GeoPoint> hole = KmlDocument.parseKmlCoordinates(this.mStringBuilder.toString());
                            polygon.mHoles.add(hole);
                        }
                    }
                } else if (localName.equals("styleUrl")) {
                    this.mKmlCurrentFeature.mStyle = this.mStringBuilder.charAt(0) == '#' ? this.mStringBuilder.substring(1) : this.mStringBuilder.toString();
                } else if (localName.equals("color")) {
                    if (this.mCurrentStyle != null) {
                        this.mColorStyle.mColor = ColorStyle.parseKMLColor(this.mStringBuilder.toString());
                    } else if (this.mKmlCurrentFeature.isA(4)) {
                        this.mKmlCurrentGroundOverlay.mColor = ColorStyle.parseKMLColor(this.mStringBuilder.toString());
                    }
                } else if (localName.equals("colorMode")) {
                    if (this.mCurrentStyle != null) {
                        this.mColorStyle.mColorMode = this.mStringBuilder.toString().equals("random") ? 1 : 0;
                    }
                } else if (localName.equals("width")) {
                    if (this.mCurrentStyle != null && this.mCurrentStyle.mLineStyle != null) {
                        this.mCurrentStyle.mLineStyle.mWidth = Float.parseFloat(this.mStringBuilder.toString());
                    }
                } else if (localName.equals("scale")) {
                    if (this.mCurrentStyle != null && this.mCurrentStyle.mIconStyle != null) {
                        this.mCurrentStyle.mIconStyle.mScale = Float.parseFloat(this.mStringBuilder.toString());
                    }
                } else if (localName.equals("heading")) {
                    if (this.mCurrentStyle != null && this.mCurrentStyle.mIconStyle != null) {
                        this.mCurrentStyle.mIconStyle.mHeading = Float.parseFloat(this.mStringBuilder.toString());
                    }
                } else if (localName.equals("href")) {
                    if (this.mCurrentStyle != null && this.mCurrentStyle.mIconStyle != null) {
                        String href = this.mStringBuilder.toString();
                        this.mCurrentStyle.setIcon(href, this.mFullPath);
                    } else if (this.mIsNetworkLink) {
                        String href = this.mStringBuilder.toString();
                        this.loadNetworkLink(href);
                    } else if (this.mKmlCurrentFeature.isA(4)) {
                        this.mKmlCurrentGroundOverlay.setIcon(this.mStringBuilder.toString(), this.mFullPath);
                    }
                } else if (localName.equals("Style")) {
                    if (this.mCurrentStyleId != null) {
                        KmlDocument.this.putStyle(this.mCurrentStyleId, this.mCurrentStyle);
                    } else {
                        this.mCurrentStyleId = KmlDocument.this.addStyle(this.mCurrentStyle);
                        if (this.mKmlCurrentFeature != null) {
                            this.mKmlCurrentFeature.mStyle = this.mCurrentStyleId;
                        }
                    }
                    this.mCurrentStyle = null;
                } else if (localName.equals("north")) {
                    this.mNorth = Double.parseDouble(this.mStringBuilder.toString());
                } else if (localName.equals("south")) {
                    this.mSouth = Double.parseDouble(this.mStringBuilder.toString());
                } else if (localName.equals("east")) {
                    this.mEast = Double.parseDouble(this.mStringBuilder.toString());
                } else if (localName.equals("west")) {
                    this.mWest = Double.parseDouble(this.mStringBuilder.toString());
                } else if (localName.equals("rotation")) {
                    this.mKmlCurrentGroundOverlay.mRotation = Float.parseFloat(this.mStringBuilder.toString());
                } else if (localName.equals("LatLonBox")) {
                    if (this.mKmlCurrentFeature.isA(4)) {
                        this.mKmlCurrentGroundOverlay.setLatLonBox(this.mNorth, this.mSouth, this.mEast, this.mWest);
                    }
                } else if (localName.equals("SimpleData")) {
                    this.mKmlCurrentFeature.setExtendedData(this.mDataName, this.mStringBuilder.toString());
                    this.mDataName = null;
                } else if (localName.equals("value")) {
                    this.mKmlCurrentFeature.setExtendedData(this.mDataName, this.mStringBuilder.toString());
                    this.mDataName = null;
                }
            }
        }
    }
}

