/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.kml;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.PorterDuff;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.osmdroid.bonuspack.kml.ColorStyle;
import org.osmdroid.bonuspack.overlays.Marker;
import org.osmdroid.bonuspack.utils.WebImageCache;

public class IconStyle
extends ColorStyle
implements Parcelable {
    public float mScale;
    public float mHeading;
    public String mHref;
    public Bitmap mIcon;
    public float mHotSpotX;
    public float mHotSpotY;
    private static WebImageCache mIconCache = new WebImageCache(100);
    public static final Parcelable.Creator<IconStyle> CREATOR = new Parcelable.Creator<IconStyle>(){

        public IconStyle createFromParcel(Parcel source) {
            return new IconStyle(source);
        }

        public IconStyle[] newArray(int size) {
            return new IconStyle[size];
        }
    };

    public IconStyle() {
        this.mScale = 1.0f;
        this.mHeading = 0.0f;
        this.mHotSpotX = 0.5f;
        this.mHotSpotY = 1.0f;
    }

    public void setIcon(String href, String containerFullPath) {
        this.mHref = href;
        if (this.mHref.startsWith("http://")) {
            this.mIcon = mIconCache.get(this.mHref);
        } else {
            File file = new File(containerFullPath);
            String actualFullPath = String.valueOf(file.getParent()) + '/' + this.mHref;
            this.mIcon = BitmapFactory.decodeFile((String)actualFullPath);
        }
    }

    public BitmapDrawable getFinalIcon(Context context) {
        if (this.mIcon == null) {
            return null;
        }
        int sizeX = Math.round((float)this.mIcon.getWidth() * this.mScale);
        int sizeY = Math.round((float)this.mIcon.getHeight() * this.mScale);
        Bitmap scaledBitmap = Bitmap.createScaledBitmap((Bitmap)this.mIcon, (int)sizeX, (int)sizeY, (boolean)true);
        BitmapDrawable marker = new BitmapDrawable(context.getResources(), scaledBitmap);
        int color = this.getFinalColor();
        if (color != 0) {
            marker.setColorFilter(color, PorterDuff.Mode.MULTIPLY);
        }
        return marker;
    }

    public void styleMarker(Marker marker, Context context) {
        BitmapDrawable icon = this.getFinalIcon(context);
        marker.setIcon((Drawable)icon);
        marker.setAnchor(this.mHotSpotX, this.mHotSpotY);
        marker.setRotation(this.mHeading);
    }

    @Override
    public void writeAsKML(Writer writer) {
        try {
            writer.write("<IconStyle>\n");
            super.writeAsKML(writer);
            if (this.mScale != 1.0f) {
                writer.write("<scale>" + this.mScale + "</scale>\n");
            }
            if (this.mHeading != 0.0f) {
                writer.write("<heading>" + this.mHeading + "</heading>\n");
            }
            if (this.mHref != null) {
                writer.write("<Icon><href>" + this.mHref + "</href></Icon>\n");
            }
            writer.write("<hotSpot x=\"" + this.mHotSpotX + "\" y=\"" + this.mHotSpotY + "\" xunits=\"fraction\" yunits=\"fraction\"/>\n");
            writer.write("</IconStyle>\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        super.writeToParcel(out, flags);
        out.writeFloat(this.mScale);
        out.writeFloat(this.mHeading);
        out.writeString(this.mHref);
        out.writeParcelable((Parcelable)this.mIcon, flags);
        out.writeFloat(this.mHotSpotX);
        out.writeFloat(this.mHotSpotY);
    }

    public IconStyle(Parcel in) {
        super(in);
        this.mScale = in.readFloat();
        this.mHeading = in.readFloat();
        this.mHref = in.readString();
        this.mIcon = (Bitmap)in.readParcelable(Bitmap.class.getClassLoader());
        this.mHotSpotX = in.readFloat();
        this.mHotSpotY = in.readFloat();
    }
}

