/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.clustering;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Point;
import android.view.MotionEvent;
import java.util.ArrayList;
import org.osmdroid.bonuspack.clustering.StaticCluster;
import org.osmdroid.bonuspack.overlays.Marker;
import org.osmdroid.views.MapView;
import org.osmdroid.views.overlay.Overlay;

public abstract class MarkerClusterer
extends Overlay {
    protected static final int FORCE_CLUSTERING = -1;
    protected ArrayList<Marker> mItems = new ArrayList();
    protected Point mPoint = new Point();
    protected ArrayList<StaticCluster> mClusters = new ArrayList();
    protected int mLastZoomLevel = -1;
    protected Bitmap mClusterIcon;

    public abstract ArrayList<StaticCluster> clusterer(MapView var1);

    public abstract Marker buildClusterMarker(StaticCluster var1, MapView var2);

    public abstract void renderer(ArrayList<StaticCluster> var1, Canvas var2, MapView var3);

    public MarkerClusterer(Context ctx) {
        super(ctx);
    }

    public void setIcon(Bitmap icon) {
        this.mClusterIcon = icon;
    }

    public void add(Marker marker) {
        this.mItems.add(marker);
    }

    public void invalidate() {
        this.mLastZoomLevel = -1;
    }

    public Marker getItem(int id) {
        return this.mItems.get(id);
    }

    public ArrayList<Marker> getItems() {
        return this.mItems;
    }

    protected void draw(Canvas canvas, MapView mapView, boolean shadow) {
        int zoomLevel = mapView.getZoomLevel();
        if (zoomLevel != this.mLastZoomLevel && !mapView.isAnimating()) {
            this.mClusters = this.clusterer(mapView);
            this.renderer(this.mClusters, canvas, mapView);
            this.mLastZoomLevel = zoomLevel;
        }
        for (StaticCluster cluster : this.mClusters) {
            cluster.getMarker().draw(canvas, mapView, shadow);
        }
    }

    public boolean onSingleTapConfirmed(MotionEvent event, MapView mapView) {
        for (StaticCluster cluster : this.mClusters) {
            if (!cluster.getMarker().onSingleTapConfirmed(event, mapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onLongPress(MotionEvent event, MapView mapView) {
        for (StaticCluster cluster : this.mClusters) {
            if (!cluster.getMarker().onLongPress(event, mapView)) continue;
            return true;
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent event, MapView mapView) {
        for (StaticCluster cluster : this.mClusters) {
            if (!cluster.getMarker().onTouchEvent(event, mapView)) continue;
            return true;
        }
        return false;
    }
}

