/*
 * Decompiled with CFR 0.152.
 */
package org.osmdroid.bonuspack.clustering;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.v4.util.LongSparseArray;
import java.util.ArrayList;
import org.osmdroid.bonuspack.clustering.MarkerClusterer;
import org.osmdroid.bonuspack.clustering.StaticCluster;
import org.osmdroid.bonuspack.overlays.Marker;
import org.osmdroid.util.BoundingBoxE6;
import org.osmdroid.views.MapView;

public class GridMarkerClusterer
extends MarkerClusterer {
    protected int mGridSize = 50;
    protected Paint mTextPaint = new Paint();
    public float mAnchorU = 0.5f;
    public float mAnchorV = 0.5f;
    public float mTextAnchorU = 0.5f;
    public float mTextAnchorV = 0.5f;

    public GridMarkerClusterer(Context ctx) {
        super(ctx);
        this.mTextPaint.setColor(-1);
        this.mTextPaint.setTextSize(15.0f);
        this.mTextPaint.setFakeBoldText(true);
        this.mTextPaint.setTextAlign(Paint.Align.CENTER);
        this.mTextPaint.setAntiAlias(true);
    }

    public Paint getTextPaint() {
        return this.mTextPaint;
    }

    public void setGridSize(int gridSize) {
        this.mGridSize = gridSize;
    }

    @Override
    public ArrayList<StaticCluster> clusterer(MapView mapView) {
        Rect mScreenRect = mapView.getIntrinsicScreenRect(null);
        BoundingBoxE6 bb = mapView.getBoundingBox();
        double latSpan = (double)bb.getLatitudeSpanE6() * 1.0E-6;
        double lonSpan = (double)bb.getLongitudeSpanE6() * 1.0E-6;
        double gridSizeX = lonSpan * (double)this.mGridSize / (double)(mScreenRect.right - mScreenRect.left);
        double gridSizeY = latSpan * (double)this.mGridSize / (double)(mScreenRect.bottom - mScreenRect.top);
        int numCellsW = (int)(360.0 / gridSizeX);
        ArrayList<StaticCluster> clusters = new ArrayList<StaticCluster>();
        LongSparseArray sparseArray = new LongSparseArray();
        for (Marker item : this.mItems) {
            long gridY;
            long gridX = (long)(item.getPosition().getLongitude() / gridSizeX);
            long coord = (long)numCellsW * gridX + (gridY = (long)(item.getPosition().getLatitude() / gridSizeY));
            StaticCluster cluster = (StaticCluster)sparseArray.get(coord);
            if (cluster == null) {
                cluster = new StaticCluster(item.getPosition());
                sparseArray.put(coord, (Object)cluster);
                clusters.add(cluster);
            }
            cluster.add(item);
        }
        return clusters;
    }

    @Override
    public Marker buildClusterMarker(StaticCluster cluster, MapView mapView) {
        Marker m = new Marker(mapView);
        m.setPosition(cluster.getPosition());
        m.setInfoWindow(null);
        m.setAnchor(this.mAnchorU, this.mAnchorV);
        Bitmap finalIcon = Bitmap.createBitmap((int)this.mClusterIcon.getWidth(), (int)this.mClusterIcon.getHeight(), (Bitmap.Config)this.mClusterIcon.getConfig());
        Canvas iconCanvas = new Canvas(finalIcon);
        iconCanvas.drawBitmap(this.mClusterIcon, 0.0f, 0.0f, null);
        String text = "" + cluster.getSize();
        int textHeight = (int)(this.mTextPaint.descent() + this.mTextPaint.ascent());
        iconCanvas.drawText(text, this.mTextAnchorU * (float)this.mClusterIcon.getWidth(), this.mTextAnchorV * (float)this.mClusterIcon.getHeight() - (float)(textHeight / 2), this.mTextPaint);
        m.setIcon((Drawable)new BitmapDrawable(mapView.getContext().getResources(), finalIcon));
        return m;
    }

    @Override
    public void renderer(ArrayList<StaticCluster> clusters, Canvas canvas, MapView mapView) {
        for (StaticCluster cluster : clusters) {
            if (cluster.getSize() == 1) {
                cluster.setMarker(cluster.getItem(0));
                continue;
            }
            Marker m = this.buildClusterMarker(cluster, mapView);
            cluster.setMarker(m);
        }
    }
}

